'use strict';

/* --------------------------------------------------------------
 core_workarounds.js 2024-10-15
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Core Workarounds Module
 *
 * This file contains workarounds that do not belong in other JS modules.
 */
gambio.widgets.module('core_workarounds', [], function () {

    'use strict';

    var module = {};

    var _initMobileMenu = function _initMobileMenu() {
        var $profile = $('#topbar-container nav > ul> li').clone(),
            $login = $profile.find('.login-off-item'),
            $loginClone = $login.clone();

        $loginClone.addClass('dropdown navbar-topbar-item');
        $login.remove();
        $profile = $profile.add($loginClone);

        // Update duplicated fields and labels with unique IDs
        $profile.find('label[for="box-login-dropdown-login-username"]').attr('for', 'cloned-login-dropdown-login-username');
        $profile.find('input[id="box-login-dropdown-login-username"]').attr('id', 'cloned-login-dropdown-login-username');
        $profile.find('label[for="box-login-dropdown-login-password"]').attr('for', 'cloned-login-dropdown-login-password');
        $profile.find('input[id="box-login-dropdown-login-password"]').attr('id', 'cloned-login-dropdown-login-password');
        $profile.find('label[for="language-switch-dropdown"]').attr('for', 'cloned-language-switch-dropdown');
        $profile.find('select[id="language-switch-dropdown"]').attr('id', 'cloned-language-switch-dropdown');
        $profile.find('label[for="countries-switch-dropdown"]').attr('for', 'cloned-countries-switch-dropdown');
        $profile.find('select[id="countries-switch-dropdown"]').attr('id', 'cloned-countries-switch-dropdown');
        $profile.find('label[for="currency-switch-dropdown"]').attr('for', 'cloned-currency-switch-dropdown');
        $profile.find('select[id="currency-switch-dropdown"]').attr('id', 'cloned-currency-switch-dropdown');

        $('#categories nav > ul').append($profile);
        $('#categories nav > ul').attr('data-gambio-widget', 'link_crypter'); //reinitialize widgets
        gambio.widgets.init($('#categories nav > ul'));

        var $verticalMenu = $('.navbar-categories-left');
        if ($verticalMenu.length > 0) {
            $verticalMenu.find('ul.level-1').append($profile.clone());

            $verticalMenu.find('ul.level-1').attr('data-gambio-widget', 'link_crypter');
            gambio.widgets.init($verticalMenu.find('ul.level-1'));

            // hide the new elements
            $verticalMenu.find('.navbar-topbar-item').hide();
        }
    };

    var _initIE11Workarounds = function _initIE11Workarounds() {
        var isIE11 = !window.ActiveXObject && "ActiveXObject" in window;
        if (!isIE11) {
            return;
        }

        // crude workaround for IE11’s inability to handle HTML5 form attributes
        var extFormButtons = $('button.extform');
        extFormButtons.each(function () {
            var formId = $(this).attr('form');
            $(this).on('click', function () {
                var formInputs = $('input[form="' + formId + '"]');
                var theForm = $('form#' + formId);
                formInputs.each(function () {
                    theForm.append($('input').attr('type', 'hidden').attr('name', $(this).attr('name')).attr('value', $(this).val()));
                });
                theForm.submit();
            });
        });
    };

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        _initMobileMenu();
        _initIE11Workarounds();

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpZGdldHMvY29yZV93b3JrYXJvdW5kcy5qcyJdLCJuYW1lcyI6WyJnYW1iaW8iLCJ3aWRnZXRzIiwibW9kdWxlIiwiX2luaXRNb2JpbGVNZW51IiwiJHByb2ZpbGUiLCIkIiwiY2xvbmUiLCIkbG9naW4iLCJmaW5kIiwiJGxvZ2luQ2xvbmUiLCJhZGRDbGFzcyIsInJlbW92ZSIsImFkZCIsImF0dHIiLCJhcHBlbmQiLCJpbml0IiwiJHZlcnRpY2FsTWVudSIsImxlbmd0aCIsImhpZGUiLCJfaW5pdElFMTFXb3JrYXJvdW5kcyIsImlzSUUxMSIsIndpbmRvdyIsIkFjdGl2ZVhPYmplY3QiLCJleHRGb3JtQnV0dG9ucyIsImVhY2giLCJmb3JtSWQiLCJvbiIsImZvcm1JbnB1dHMiLCJ0aGVGb3JtIiwidmFsIiwic3VibWl0IiwiZG9uZSJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7Ozs7Ozs7OztBQVVBOzs7OztBQUtBQSxPQUFPQyxPQUFQLENBQWVDLE1BQWYsQ0FBc0Isa0JBQXRCLEVBQTBDLEVBQTFDLEVBQThDLFlBQVk7O0FBRXREOztBQUVBLFFBQUlBLFNBQVMsRUFBYjs7QUFFQSxRQUFJQyxrQkFBa0IsU0FBbEJBLGVBQWtCLEdBQVk7QUFDOUIsWUFBSUMsV0FBV0MsRUFBRSxnQ0FBRixFQUFvQ0MsS0FBcEMsRUFBZjtBQUFBLFlBQ0lDLFNBQVNILFNBQVNJLElBQVQsQ0FBYyxpQkFBZCxDQURiO0FBQUEsWUFFSUMsY0FBY0YsT0FBT0QsS0FBUCxFQUZsQjs7QUFJQUcsb0JBQVlDLFFBQVosQ0FBcUIsNkJBQXJCO0FBQ0FILGVBQU9JLE1BQVA7QUFDQVAsbUJBQVdBLFNBQVNRLEdBQVQsQ0FBYUgsV0FBYixDQUFYOztBQUVBO0FBQ0FMLGlCQUFTSSxJQUFULENBQWMsZ0RBQWQsRUFBZ0VLLElBQWhFLENBQXFFLEtBQXJFLEVBQTRFLHNDQUE1RTtBQUNBVCxpQkFBU0ksSUFBVCxDQUFjLCtDQUFkLEVBQStESyxJQUEvRCxDQUFvRSxJQUFwRSxFQUEwRSxzQ0FBMUU7QUFDQVQsaUJBQVNJLElBQVQsQ0FBYyxnREFBZCxFQUFnRUssSUFBaEUsQ0FBcUUsS0FBckUsRUFBNEUsc0NBQTVFO0FBQ0FULGlCQUFTSSxJQUFULENBQWMsK0NBQWQsRUFBK0RLLElBQS9ELENBQW9FLElBQXBFLEVBQTBFLHNDQUExRTtBQUNBVCxpQkFBU0ksSUFBVCxDQUFjLHVDQUFkLEVBQXVESyxJQUF2RCxDQUE0RCxLQUE1RCxFQUFtRSxpQ0FBbkU7QUFDQVQsaUJBQVNJLElBQVQsQ0FBYyx1Q0FBZCxFQUF1REssSUFBdkQsQ0FBNEQsSUFBNUQsRUFBa0UsaUNBQWxFO0FBQ0FULGlCQUFTSSxJQUFULENBQWMsd0NBQWQsRUFBd0RLLElBQXhELENBQTZELEtBQTdELEVBQW9FLGtDQUFwRTtBQUNBVCxpQkFBU0ksSUFBVCxDQUFjLHdDQUFkLEVBQXdESyxJQUF4RCxDQUE2RCxJQUE3RCxFQUFtRSxrQ0FBbkU7QUFDQVQsaUJBQVNJLElBQVQsQ0FBYyx1Q0FBZCxFQUF1REssSUFBdkQsQ0FBNEQsS0FBNUQsRUFBbUUsaUNBQW5FO0FBQ0FULGlCQUFTSSxJQUFULENBQWMsdUNBQWQsRUFBdURLLElBQXZELENBQTRELElBQTVELEVBQWtFLGlDQUFsRTs7QUFFQVIsVUFBRSxzQkFBRixFQUEwQlMsTUFBMUIsQ0FBaUNWLFFBQWpDO0FBQ0FDLFVBQUUsc0JBQUYsRUFBMEJRLElBQTFCLENBQStCLG9CQUEvQixFQUFxRCxjQUFyRCxFQXRCOEIsQ0FzQnlDO0FBQ3ZFYixlQUFPQyxPQUFQLENBQWVjLElBQWYsQ0FBb0JWLEVBQUUsc0JBQUYsQ0FBcEI7O0FBRUEsWUFBSVcsZ0JBQWdCWCxFQUFFLHlCQUFGLENBQXBCO0FBQ0EsWUFBSVcsY0FBY0MsTUFBZCxHQUF1QixDQUEzQixFQUE4QjtBQUMxQkQsMEJBQWNSLElBQWQsQ0FBbUIsWUFBbkIsRUFBaUNNLE1BQWpDLENBQXdDVixTQUFTRSxLQUFULEVBQXhDOztBQUVBVSwwQkFBY1IsSUFBZCxDQUFtQixZQUFuQixFQUFpQ0ssSUFBakMsQ0FBc0Msb0JBQXRDLEVBQTRELGNBQTVEO0FBQ0FiLG1CQUFPQyxPQUFQLENBQWVjLElBQWYsQ0FBb0JDLGNBQWNSLElBQWQsQ0FBbUIsWUFBbkIsQ0FBcEI7O0FBRUE7QUFDQVEsMEJBQWNSLElBQWQsQ0FBbUIscUJBQW5CLEVBQTBDVSxJQUExQztBQUNIO0FBQ0osS0FuQ0Q7O0FBcUNBLFFBQUlDLHVCQUF1QixTQUF2QkEsb0JBQXVCLEdBQVk7QUFDbkMsWUFBSUMsU0FBUyxDQUFFQyxPQUFPQyxhQUFULElBQTJCLG1CQUFtQkQsTUFBM0Q7QUFDQSxZQUFHLENBQUNELE1BQUosRUFBWTtBQUNSO0FBQ0g7O0FBRUQ7QUFDQSxZQUFJRyxpQkFBaUJsQixFQUFFLGdCQUFGLENBQXJCO0FBQ0FrQix1QkFBZUMsSUFBZixDQUFvQixZQUFXO0FBQzNCLGdCQUFJQyxTQUFTcEIsRUFBRSxJQUFGLEVBQVFRLElBQVIsQ0FBYSxNQUFiLENBQWI7QUFDQVIsY0FBRSxJQUFGLEVBQVFxQixFQUFSLENBQVcsT0FBWCxFQUFvQixZQUFXO0FBQzNCLG9CQUFJQyxhQUFhdEIsRUFBRSxpQkFBaUJvQixNQUFqQixHQUEwQixJQUE1QixDQUFqQjtBQUNBLG9CQUFJRyxVQUFVdkIsRUFBRSxVQUFVb0IsTUFBWixDQUFkO0FBQ0FFLDJCQUFXSCxJQUFYLENBQWdCLFlBQVc7QUFDdkJJLDRCQUFRZCxNQUFSLENBQWVULEVBQUUsT0FBRixFQUFXUSxJQUFYLENBQWdCLE1BQWhCLEVBQXdCLFFBQXhCLEVBQWtDQSxJQUFsQyxDQUF1QyxNQUF2QyxFQUErQ1IsRUFBRSxJQUFGLEVBQVFRLElBQVIsQ0FBYSxNQUFiLENBQS9DLEVBQXFFQSxJQUFyRSxDQUEwRSxPQUExRSxFQUFtRlIsRUFBRSxJQUFGLEVBQVF3QixHQUFSLEVBQW5GLENBQWY7QUFDSCxpQkFGRDtBQUdBRCx3QkFBUUUsTUFBUjtBQUNILGFBUEQ7QUFRSCxTQVZEO0FBV0gsS0FuQkQ7O0FBcUJBOzs7O0FBSUE1QixXQUFPYSxJQUFQLEdBQWMsVUFBVWdCLElBQVYsRUFBZ0I7QUFDMUI1QjtBQUNBZ0I7O0FBRUFZO0FBQ0gsS0FMRDs7QUFPQSxXQUFPN0IsTUFBUDtBQUNILENBNUVEIiwiZmlsZSI6IndpZGdldHMvY29yZV93b3JrYXJvdW5kcy5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG4gY29yZV93b3JrYXJvdW5kcy5qcyAyMDI0LTEwLTE1XG4gR2FtYmlvIEdtYkhcbiBodHRwOi8vd3d3LmdhbWJpby5kZVxuIENvcHlyaWdodCAoYykgMjAxNSBHYW1iaW8gR21iSFxuIFJlbGVhc2VkIHVuZGVyIHRoZSBHTlUgR2VuZXJhbCBQdWJsaWMgTGljZW5zZSAoVmVyc2lvbiAyKVxuIFtodHRwOi8vd3d3LmdudS5vcmcvbGljZW5zZXMvZ3BsLTIuMC5odG1sXVxuIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG4gKi9cblxuLyoqXG4gKiBDb3JlIFdvcmthcm91bmRzIE1vZHVsZVxuICpcbiAqIFRoaXMgZmlsZSBjb250YWlucyB3b3JrYXJvdW5kcyB0aGF0IGRvIG5vdCBiZWxvbmcgaW4gb3RoZXIgSlMgbW9kdWxlcy5cbiAqL1xuZ2FtYmlvLndpZGdldHMubW9kdWxlKCdjb3JlX3dvcmthcm91bmRzJywgW10sIGZ1bmN0aW9uICgpIHtcblxuICAgICd1c2Ugc3RyaWN0JztcblxuICAgIHZhciBtb2R1bGUgPSB7fTtcblxuICAgIHZhciBfaW5pdE1vYmlsZU1lbnUgPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgIHZhciAkcHJvZmlsZSA9ICQoJyN0b3BiYXItY29udGFpbmVyIG5hdiA+IHVsPiBsaScpLmNsb25lKCksXG4gICAgICAgICAgICAkbG9naW4gPSAkcHJvZmlsZS5maW5kKCcubG9naW4tb2ZmLWl0ZW0nKSxcbiAgICAgICAgICAgICRsb2dpbkNsb25lID0gJGxvZ2luLmNsb25lKCk7XG5cbiAgICAgICAgJGxvZ2luQ2xvbmUuYWRkQ2xhc3MoJ2Ryb3Bkb3duIG5hdmJhci10b3BiYXItaXRlbScpO1xuICAgICAgICAkbG9naW4ucmVtb3ZlKCk7XG4gICAgICAgICRwcm9maWxlID0gJHByb2ZpbGUuYWRkKCRsb2dpbkNsb25lKTtcbiAgICAgICAgXG4gICAgICAgIC8vIFVwZGF0ZSBkdXBsaWNhdGVkIGZpZWxkcyBhbmQgbGFiZWxzIHdpdGggdW5pcXVlIElEc1xuICAgICAgICAkcHJvZmlsZS5maW5kKCdsYWJlbFtmb3I9XCJib3gtbG9naW4tZHJvcGRvd24tbG9naW4tdXNlcm5hbWVcIl0nKS5hdHRyKCdmb3InLCAnY2xvbmVkLWxvZ2luLWRyb3Bkb3duLWxvZ2luLXVzZXJuYW1lJyk7XG4gICAgICAgICRwcm9maWxlLmZpbmQoJ2lucHV0W2lkPVwiYm94LWxvZ2luLWRyb3Bkb3duLWxvZ2luLXVzZXJuYW1lXCJdJykuYXR0cignaWQnLCAnY2xvbmVkLWxvZ2luLWRyb3Bkb3duLWxvZ2luLXVzZXJuYW1lJyk7XG4gICAgICAgICRwcm9maWxlLmZpbmQoJ2xhYmVsW2Zvcj1cImJveC1sb2dpbi1kcm9wZG93bi1sb2dpbi1wYXNzd29yZFwiXScpLmF0dHIoJ2ZvcicsICdjbG9uZWQtbG9naW4tZHJvcGRvd24tbG9naW4tcGFzc3dvcmQnKTtcbiAgICAgICAgJHByb2ZpbGUuZmluZCgnaW5wdXRbaWQ9XCJib3gtbG9naW4tZHJvcGRvd24tbG9naW4tcGFzc3dvcmRcIl0nKS5hdHRyKCdpZCcsICdjbG9uZWQtbG9naW4tZHJvcGRvd24tbG9naW4tcGFzc3dvcmQnKTtcbiAgICAgICAgJHByb2ZpbGUuZmluZCgnbGFiZWxbZm9yPVwibGFuZ3VhZ2Utc3dpdGNoLWRyb3Bkb3duXCJdJykuYXR0cignZm9yJywgJ2Nsb25lZC1sYW5ndWFnZS1zd2l0Y2gtZHJvcGRvd24nKTtcbiAgICAgICAgJHByb2ZpbGUuZmluZCgnc2VsZWN0W2lkPVwibGFuZ3VhZ2Utc3dpdGNoLWRyb3Bkb3duXCJdJykuYXR0cignaWQnLCAnY2xvbmVkLWxhbmd1YWdlLXN3aXRjaC1kcm9wZG93bicpO1xuICAgICAgICAkcHJvZmlsZS5maW5kKCdsYWJlbFtmb3I9XCJjb3VudHJpZXMtc3dpdGNoLWRyb3Bkb3duXCJdJykuYXR0cignZm9yJywgJ2Nsb25lZC1jb3VudHJpZXMtc3dpdGNoLWRyb3Bkb3duJyk7XG4gICAgICAgICRwcm9maWxlLmZpbmQoJ3NlbGVjdFtpZD1cImNvdW50cmllcy1zd2l0Y2gtZHJvcGRvd25cIl0nKS5hdHRyKCdpZCcsICdjbG9uZWQtY291bnRyaWVzLXN3aXRjaC1kcm9wZG93bicpO1xuICAgICAgICAkcHJvZmlsZS5maW5kKCdsYWJlbFtmb3I9XCJjdXJyZW5jeS1zd2l0Y2gtZHJvcGRvd25cIl0nKS5hdHRyKCdmb3InLCAnY2xvbmVkLWN1cnJlbmN5LXN3aXRjaC1kcm9wZG93bicpO1xuICAgICAgICAkcHJvZmlsZS5maW5kKCdzZWxlY3RbaWQ9XCJjdXJyZW5jeS1zd2l0Y2gtZHJvcGRvd25cIl0nKS5hdHRyKCdpZCcsICdjbG9uZWQtY3VycmVuY3ktc3dpdGNoLWRyb3Bkb3duJyk7XG5cbiAgICAgICAgJCgnI2NhdGVnb3JpZXMgbmF2ID4gdWwnKS5hcHBlbmQoJHByb2ZpbGUpO1xuICAgICAgICAkKCcjY2F0ZWdvcmllcyBuYXYgPiB1bCcpLmF0dHIoJ2RhdGEtZ2FtYmlvLXdpZGdldCcsICdsaW5rX2NyeXB0ZXInKTsgIC8vcmVpbml0aWFsaXplIHdpZGdldHNcbiAgICAgICAgZ2FtYmlvLndpZGdldHMuaW5pdCgkKCcjY2F0ZWdvcmllcyBuYXYgPiB1bCcpKTtcblxuICAgICAgICB2YXIgJHZlcnRpY2FsTWVudSA9ICQoJy5uYXZiYXItY2F0ZWdvcmllcy1sZWZ0Jyk7XG4gICAgICAgIGlmICgkdmVydGljYWxNZW51Lmxlbmd0aCA+IDApIHtcbiAgICAgICAgICAgICR2ZXJ0aWNhbE1lbnUuZmluZCgndWwubGV2ZWwtMScpLmFwcGVuZCgkcHJvZmlsZS5jbG9uZSgpKTtcblxuICAgICAgICAgICAgJHZlcnRpY2FsTWVudS5maW5kKCd1bC5sZXZlbC0xJykuYXR0cignZGF0YS1nYW1iaW8td2lkZ2V0JywgJ2xpbmtfY3J5cHRlcicpO1xuICAgICAgICAgICAgZ2FtYmlvLndpZGdldHMuaW5pdCgkdmVydGljYWxNZW51LmZpbmQoJ3VsLmxldmVsLTEnKSk7XG5cbiAgICAgICAgICAgIC8vIGhpZGUgdGhlIG5ldyBlbGVtZW50c1xuICAgICAgICAgICAgJHZlcnRpY2FsTWVudS5maW5kKCcubmF2YmFyLXRvcGJhci1pdGVtJykuaGlkZSgpO1xuICAgICAgICB9XG4gICAgfTtcblxuICAgIHZhciBfaW5pdElFMTFXb3JrYXJvdW5kcyA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgdmFyIGlzSUUxMSA9ICEod2luZG93LkFjdGl2ZVhPYmplY3QpICYmIFwiQWN0aXZlWE9iamVjdFwiIGluIHdpbmRvdztcbiAgICAgICAgaWYoIWlzSUUxMSkge1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gY3J1ZGUgd29ya2Fyb3VuZCBmb3IgSUUxMeKAmXMgaW5hYmlsaXR5IHRvIGhhbmRsZSBIVE1MNSBmb3JtIGF0dHJpYnV0ZXNcbiAgICAgICAgdmFyIGV4dEZvcm1CdXR0b25zID0gJCgnYnV0dG9uLmV4dGZvcm0nKTtcbiAgICAgICAgZXh0Rm9ybUJ1dHRvbnMuZWFjaChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIHZhciBmb3JtSWQgPSAkKHRoaXMpLmF0dHIoJ2Zvcm0nKTtcbiAgICAgICAgICAgICQodGhpcykub24oJ2NsaWNrJywgZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICAgICAgdmFyIGZvcm1JbnB1dHMgPSAkKCdpbnB1dFtmb3JtPVwiJyArIGZvcm1JZCArICdcIl0nKTtcbiAgICAgICAgICAgICAgICB2YXIgdGhlRm9ybSA9ICQoJ2Zvcm0jJyArIGZvcm1JZCk7XG4gICAgICAgICAgICAgICAgZm9ybUlucHV0cy5lYWNoKGZ1bmN0aW9uKCkge1xuICAgICAgICAgICAgICAgICAgICB0aGVGb3JtLmFwcGVuZCgkKCdpbnB1dCcpLmF0dHIoJ3R5cGUnLCAnaGlkZGVuJykuYXR0cignbmFtZScsICQodGhpcykuYXR0cignbmFtZScpKS5hdHRyKCd2YWx1ZScsICQodGhpcykudmFsKCkpKTtcbiAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgIHRoZUZvcm0uc3VibWl0KCk7XG4gICAgICAgICAgICB9KVxuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBJbml0IGZ1bmN0aW9uIG9mIHRoZSB3aWRnZXRcbiAgICAgKiBAY29uc3RydWN0b3JcbiAgICAgKi9cbiAgICBtb2R1bGUuaW5pdCA9IGZ1bmN0aW9uIChkb25lKSB7XG4gICAgICAgIF9pbml0TW9iaWxlTWVudSgpO1xuICAgICAgICBfaW5pdElFMTFXb3JrYXJvdW5kcygpO1xuICAgICAgICBcbiAgICAgICAgZG9uZSgpO1xuICAgIH07XG5cbiAgICByZXR1cm4gbW9kdWxlO1xufSk7XG4iXX0=
